
/*  1. Vienas kolonnas kārtošana (klikšķis uz tabulas virsraksta)
   Funkcija maina kārtošanas secību (A-Z → Z-A) */
function sortTable(columnIndex) {
  const table = document.getElementById("dataTable");
  let switching = true;
  let shouldSwitch;
  let direction = "asc";
  let switchCount = 0;

  while (switching) {
    switching = false;
    const rows = table.rows;

    for (let i = 2; i < rows.length - 1; i++) { // sāk no rindas pēc virsraksta
      shouldSwitch = false;
      const x = rows[i].getElementsByTagName("TD")[columnIndex];
      const y = rows[i + 1].getElementsByTagName("TD")[columnIndex];
      if (direction === "asc" && x.innerHTML.toLowerCase() > y.innerHTML.toLowerCase()) {
        shouldSwitch = true;
        break;
      } else if (direction === "desc" && x.innerHTML.toLowerCase() < y.innerHTML.toLowerCase()) {
        shouldSwitch = true;
        break;
      }
    }

    if (shouldSwitch) {
      rows[0].parentNode.insertBefore(rows[i + 1], rows[i]);
      switching = true;
      switchCount++;
    } else {
      if (switchCount === 0 && direction === "asc") {
        direction = "desc";
        switching = true;
      }
    }
  }
}

/*  2. Vispārējā meklēšana – filtrē visā tabulā */
function searchTable() {
  const input = document.getElementById("searchInput");
  const filter = input.value.toLowerCase();
  const table = document.getElementById("dataTable");
  const tr = table.getElementsByTagName("tr");

  for (let i = 2; i < tr.length; i++) {
    let tds = tr[i].getElementsByTagName("td");
    let rowMatch = false;
    for (let td of tds) {
      if (td.innerHTML.toLowerCase().includes(filter)) {
        rowMatch = true;
        break;
      }
    }
    tr[i].style.display = rowMatch ? "" : "none";
  }
}

/*  3. Filtrēšana pēc konkrētas kolonnas */
function filterByColumn(colIndex) {
  const table = document.getElementById("dataTable");
  const filterInputs = document.querySelectorAll("#columnFilters input");
  const rows = table.getElementsByTagName("tr");

  for (let i = 2; i < rows.length; i++) {
    let showRow = true;
    for (let j = 0; j < filterInputs.length; j++) {
      const filterValue = filterInputs[j].value.toLowerCase();
      const cell = rows[i].getElementsByTagName("td")[j];
      if (filterValue && !cell.innerHTML.toLowerCase().includes(filterValue)) {
        showRow = false;
        break;
      }
    }
    rows[i].style.display = showRow ? "" : "none";
  }
}

/*  4. Ieraksta dzēšana ar AJAX (bez lapas pārlādes)
   - Nosūta dzēšanas pieprasījumu uz dell.php
   - Parāda rezultātu #result laukā */
function deleteRecord(id) {
  if (!confirm("Vai tiešām dzēst šo ierakstu?")) return;

  fetch("dell.php?id=" + id)
    .then(response => response.text())
    .then(data => {
      document.getElementById("result").innerHTML = data;
      // Pēc dzēšanas automātiski noņem rindu no tabulas
      const row = document.querySelector(`button[onclick="deleteRecord(${id})"]`).closest("tr");
      row.remove();
    })
    .catch(error => {
      document.getElementById("result").innerHTML = "❌ Kļūda: " + error;
    });
}
